#!/usr/bin/env bash
set -e

options="--all -10"
messages_command="git log --pretty=tformat:'%s' ${options[@]}"
lines_command="git log --pretty=tformat:'<b>%h</b> -  __XX123XX__ </li>' ${options[@]}"

# damn bash arrays
OLDIFS=$IFS
IFS=$'\n'

messages=($(bash -c "$messages_command"))
lines=($(bash -c "$lines_command"))

IFS=$OLDIFS

mlen=${#messages[@]}
llen=${#lines[@]}

OUTPUT=${OUTPUT}"<ul>"
for (( i=0; i<${mlen}; i++ )); do
  message=$(perl -MHTML::Entities -e '$msg=encode_entities($ARGV[1]);$l=$ARGV[0];$l =~ s/__XX123XX__/$msg/;print $l;' "${lines[$i]}" "${messages[$i]}")
  OUTPUT=${OUTPUT}"<li>$message"
done
OUTPUT=${OUTPUT}"</ul>"

echo $OUTPUT

