#!/bin/bash

## Copyright (C) 2010-2019 Yann Pouillon
##
## This file is part of the LibGridXC software package. For license information,
## please see the COPYING file in the top-level directory of the source
## distribution.

#
# IMPORTANT NOTE:
#
#   For maintainer use only!
#
#   PLEASE DO NOT EDIT THIS FILE, AS IT COULD CAUSE A SERIOUS LOSS OF DATA.
#   *** YOU HAVE BEEN WARNED! ***
#

# Check that we are in the right directory
if test ! -s "./configure.ac" -o ! -s "src/atomxc.F90"; then
  echo "wipeout: Cowardly refusing to remove something from here!"
  exit 1
fi

# Fix permissions
chmod -R u+w .

# Remove temporary directories and files
echo "Removing temporary directories and files..."
rm -rf tmp*
find . -depth -name 'tmp-*' -exec rm -rf {} \;
find src -name '*.~[0-9]~' -exec rm -f {} \;
find docs -name '*~' -exec rm -f {} \;
echo "done."

# Remove autotools files
echo "Removing autotools files..."
find src -depth -name '.deps' -exec rm -rf {} \;
find src -depth -name '.libs' -exec rm -rf {} \;
find . -name '*.pc' -exec rm {} \;
rm -f core config.log config.status stamp-h1 config.h config.h.in*
rm -rf aclocal.m4 autom4te.cache configure confstat*
(test -d config/data && cd config/data && rm -f gridxc.mk libgridxc-config.yml libgridxc.pc libxc.mk)
(test -d config/gnu && cd config/gnu && rm -f compile config.guess config.sub depcomp install-sh ltmain.sh missing test-driver)
(test -d config/m4 && cd config/m4 && rm -f libtool.m4 ltoptions.m4 ltsugar.m4 ltversion.m4 lt~obsolete.m4)
echo "done."

# Remove Makefiles and machine-generated files
echo "Removing generated makefiles and libtool scripts..."
rm -f libtool
find . -name Makefile -exec rm {} \;
find . -name Makefile.in -exec rm {} \;
echo "done."

# Remove object files, libraries and programs
echo "Removing object files, libraries and programs..."
for subdir in Testers src; do
  find "${subdir}" -name '*.a' -o -name '*.o' -exec rm {} \;
  find "${subdir}" -name '*.la' -o -name '*.lo' -exec rm {} \;
  find "${subdir}" -name '*.mod' -exec rm {} \;
  find "${subdir}" -name '*.x' -exec rm {} \;
done
echo "done."

# Remove script-generated documentation
echo "Removing script-generated documentation..."
rm -rf doc/developers/latex doc/developers/source
echo "done."

# Remove test-related files
echo "Removing files produced by the test suite..."
for prog in test1 test2 test3 test4 test5 test6 test_libxc test_libxc2 test_match; do
  (cd Testers && rm -f ${prog} ${prog}.Vxc ${prog}.log ${prog}.trs)
done
(cd Testers && rm -rf .libs test-suite.log vdw_kernel.table)
echo "done."

# Remove distribution files
echo "Removing distribution files..."
rm -rf libgridxc-[0-9].[0-9].[0-9]*
echo "done."
