function ndynin(sddyna, chaine)
!
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: mickael.abbas at edf.fr
!
    implicit none
    integer :: ndynin
#include "jeveux.h"
#include "asterfort/assert.h"
#include "asterfort/jedema.h"
#include "asterfort/jemarq.h"
#include "asterfort/jeveuo.h"
    character(len=19) :: sddyna
    character(len=*) :: chaine
!
! ----------------------------------------------------------------------
!
! ROUTINE MECA_NON_LINE (UTILITAIRE)
!
! INTERROGE SDDYNA POUR RENVOYER UN ENTIER
!
! ----------------------------------------------------------------------
!
!
! OUT NDYNIN : TYPE DE FORMULATION
!            -> 1 : FORMULATION EN DEPLACEMENT
!            -> 2 : FORMULATION EN VITESSE
!            -> 3 : FORMULATION EN ACCELERATION
! IN  SDDYNA : NOM DE LA SD DEDIEE A LA DYNAMIQUE
! IN  CHAINE :  = / 'FORMUL_CONTACT'
!                 / 'FORMUL_DYNAMIQUE'
!
!
!
!
!
    integer :: jtfor, jncha
    character(len=24) :: tfor, ncha
!
! ----------------------------------------------------------------------
!
    call jemarq()
!
! --- INITIALISATIONS
!
    ndynin = 0
!
! --- INTERROGATION
!
    tfor = sddyna(1:15)//'.TYPE_FOR'
    ncha = sddyna(1:15)//'.NBRE_CHA'
    call jeveuo(tfor, 'L', jtfor)
    call jeveuo(ncha, 'L', jncha)
    if (chaine .eq. 'FORMUL_DYNAMIQUE') then
        ndynin = zi(jtfor+1-1)
    else if (chaine.eq.'NBRE_EXCIT') then
        ndynin = zi(jncha+1-1)
    else if (chaine.eq.'NBRE_ONDE_PLANE') then
        ndynin = zi(jncha+2-1)
    else if (chaine.eq.'NBRE_EXCIT_GENE') then
        ndynin = zi(jncha+3-1)
    else if (chaine.eq.'NBRE_MODE_AMOR') then
        ndynin = zi(jncha+4-1)
    else if (chaine.eq.'NBRE_MODE_PROJ') then
        ndynin = zi(jncha+5-1)
    else
        call assert(.false.)
    endif
!
    call jedema()
end function
