// Aseprite Base Library
// Copyright (c) 2001-2013 David Capello
//
// This file is released under the terms of the MIT license.
// Read LICENSE.txt for more information.

#ifndef BASE_CONVERT_TO_H_INCLUDED
#define BASE_CONVERT_TO_H_INCLUDED
#pragma once

#include <string>

namespace base {

  class Sha1;
  class Version;

  // Undefined convertion
  template<typename To, typename From>
  To convert_to(const From& from) {
    static_assert(false && sizeof(To), "Invalid conversion");
  }

  template<> int convert_to(const std::string& from);
  template<> std::string convert_to(const int& from);

  template<> Sha1 convert_to(const std::string& from);
  template<> std::string convert_to(const Sha1& from);

  template<> Version convert_to(const std::string& from);
  template<> std::string convert_to(const Version& from);

}

#endif
