#! perl

use strict;
use warnings;

use Benchmark qw(:all);

my $interp = join '|', qw(a..z);
my $compiled = qr/$interp/;

cmpthese(-1, {
	      'Plain' =>
	      sub {
		  'test' =~ /$interp/;
	      },
	      'OnDemand' =>
	      sub {
		  $interp = qr/$interp/ unless ref $interp;
		  'test' =~ /$interp/;
	      },
	      'PreCompile' =>
	      sub {
		  'test' =~ /$compiled/;
	      },
	      'Once' =>
	      sub {
		  'test' =~ /$interp/o;
	      }
	     });
