#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Star Wolves 3: Civil War
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250828.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='star-wolves-3'
GAME_NAME='Star Wolves 3: Civil War'

ARCHIVE_BASE_0_NAME='setup_star_wolves3_2.0.0.2.exe'
ARCHIVE_BASE_0_MD5='63b8ef96c0978b068d5df2a7af8125fa'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_0_PART1_NAME='setup_star_wolves3_2.0.0.2-1.bin'
ARCHIVE_BASE_0_PART1_MD5='f057ab5db4ad8e2b4d21703b65e07b5f'
ARCHIVE_BASE_0_PART1_EXTRACTOR='unar'
ARCHIVE_BASE_0_SIZE='4860136'
ARCHIVE_BASE_0_VERSION='1.12-gog2.0.0.2'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/star_wolves_3_civil_war'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
binkw32.dll
dbghelp.dll
zlib1.dll
sw3cw.exe'
CONTENT_GAME0_BIN_PATH='support/app'
CONTENT_GAME0_BIN_FILES='
default.cfg
Main.ini'
CONTENT_GAME_DATA_FILES='
Data'
CONTENT_DOC_DATA_FILES='
Manual.pdf'

USER_PERSISTENT_DIRECTORIES='
profiles'
USER_PERSISTENT_FILES='
default.cfg
Main.ini'

APP_MAIN_EXE='sw3cw.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
