#!/bin/sh

echo "If your language does not use the same plural forms as English,"
echo "support for your language has to be explicitly coded into the"
echo "l10n module of the stylesheets.  In order to ensure correctness,"
echo "this file is automatically generated from those stylesheets to"
echo "provide a simple overview of the supported languages and their"
echo "plural forms.  Please take a minute to verify that the plural"
echo "forms for your language are correct."
echo;

echo "Does your language use the same plural forms as English?"
echo "That is, does your plural form rule in PO files look like"
echo "this: 'plural=(n != 1);'?  If so, there is no explicit rule";
echo "for your language.  Instead, it will be caught be the rule"
echo "by the plural form rule for the 'C' locale."
echo;

langs=`xml sel \
    -N "x=http://www.w3.org/1999/XSL/Transform" \
    -t -m "/*/x:template[@name='l10n.plural.form']/x:choose/x:when" \
    -v "@test" \
    ../xslt/gettext/gettext.xsl \
    | sed -e "s/^[^']*'//" -e "s/'[^']*'/\n/g" -e "s/'[^']*$//" \
    | grep -v '^_$' | sort`

echo "`echo $langs | wc -w` other languages supported";
echo;

for lang in $langs; do
    langstring="$lang"
    if test -f ../po/$lang.po; then
	langname=`head -1 ../po/$lang.po \
	    | grep '# .* translation' \
	    | sed -e "s/^# //" -e "s/ translation.*$//"`;
	if test "x$langname" != "x"; then
	    langstring="$langstring ($langname)";
	fi;
    elif test "x$lang" = "xzh"; then
	langstring="$langstring (Chinese)";
    fi;
    echo $langstring;
    whens=`xml sel \
	-N "x=http://www.w3.org/1999/XSL/Transform" \
	-t -m "/*/x:template[@name='l10n.plural.form']/x:choose" \
	-m "x:when[contains(@test, concat(&quot;= '&quot;, '$lang'))]" \
	-v "count(x:choose/x:when)" \
	../xslt/gettext/gettext.xsl`;
    if test "x$whens" = "x0"; then
	echo "1 plural form";
    else
        echo -n `echo $whens + 1 | bc`
	echo " plural forms"
	i=0;
	while test $i \< $whens; do
	    echo -n "  $i: ";
	    test=`xml sel \
		-N "x=http://www.w3.org/1999/XSL/Transform" \
		-t -m "/*/x:template[@name='l10n.plural.form']/x:choose" \
		-m "x:when[contains(@test, concat(&quot;= '&quot;, '$lang'))]" \
		-m "x:choose/x:when[$i + 1]" \
		-v "@test" \
		../xslt/gettext/gettext.xsl`;
	    test=`echo $test | sed \
		-e "s/\\$number/n/g" -e "s/mod/%/g" \
		-e "s/&gt;/>/g" -e "s/&lt;/</g" \
		-e "s/and/\\&\\&/g" -e "s/or/||/g"`
	    echo $test;
	    i=`echo $i + 1 | bc`;
	done;
	echo "  $whens: ELSE"
    fi;
    echo;
done;
