/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Clicker;
import junit.framework.Assert;

class TextEnterer {
    private final Instrumentation inst;
    private final Clicker clicker;
    private final ActivityUtils activityUtils;

    public TextEnterer(Instrumentation inst, ActivityUtils activityUtils, Clicker clicker) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.clicker = clicker;
    }

    public void setEditText(final EditText editText, final String text) {
        if (editText != null) {
            final String previousText = editText.getText().toString();
            if (!editText.isEnabled()) {
                Assert.assertTrue((String)"Edit text is not enabled!", (boolean)false);
            }
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                    editText.performClick();
                    TextEnterer.this.closeSoftKeyboard(editText);
                    if (text.equals("")) {
                        editText.setText((CharSequence)text);
                    } else {
                        editText.setText((CharSequence)(previousText + text));
                        editText.setCursorVisible(false);
                    }
                }
            });
        }
    }

    public void typeText(final EditText editText, String text) {
        if (editText != null) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                }
            });
            this.clicker.clickOnScreen((View)editText, false, 0);
            this.closeSoftKeyboard(editText);
            this.inst.sendStringSync(text);
        }
    }

    private void closeSoftKeyboard(EditText editText) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        this.activityUtils.getCurrentActivity(false);
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }
}

