/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020-2023 Intel Corporation
 */

#ifndef __IVPU_HW_BTRS_MTL_REG_H__
#define __IVPU_HW_BTRS_MTL_REG_H__

#include <linux/bits.h>

#define VPU_HW_BTRS_MTL_INTERRUPT_TYPE				0x00000000u

#define VPU_HW_BTRS_MTL_INTERRUPT_STAT				0x00000004u
#define VPU_HW_BTRS_MTL_INTERRUPT_STAT_FREQ_CHANGE_MASK		BIT_MASK(0)
#define VPU_HW_BTRS_MTL_INTERRUPT_STAT_ATS_ERR_MASK		BIT_MASK(1)
#define VPU_HW_BTRS_MTL_INTERRUPT_STAT_UFI_ERR_MASK		BIT_MASK(2)

#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD0				0x00000008u
#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD0_MIN_RATIO_MASK		GENMASK(15, 0)
#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD0_MAX_RATIO_MASK		GENMASK(31, 16)

#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD1				0x0000000cu
#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD1_TARGET_RATIO_MASK	GENMASK(15, 0)
#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD1_EPP_MASK		GENMASK(31, 16)

#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD2				0x00000010u
#define VPU_HW_BTRS_MTL_WP_REQ_PAYLOAD2_CONFIG_MASK		GENMASK(15, 0)

#define VPU_HW_BTRS_MTL_WP_REQ_CMD				0x00000014u
#define VPU_HW_BTRS_MTL_WP_REQ_CMD_SEND_MASK			BIT_MASK(0)

#define VPU_HW_BTRS_MTL_WP_DOWNLOAD				0x00000018u
#define VPU_HW_BTRS_MTL_WP_DOWNLOAD_TARGET_RATIO_MASK		GENMASK(15, 0)

#define VPU_HW_BTRS_MTL_CURRENT_PLL				0x0000001cu
#define VPU_HW_BTRS_MTL_CURRENT_PLL_RATIO_MASK			GENMASK(15, 0)

#define VPU_HW_BTRS_MTL_PLL_ENABLE				0x00000020u

#define VPU_HW_BTRS_MTL_FMIN_FUSE				0x00000024u
#define VPU_HW_BTRS_MTL_FMIN_FUSE_MIN_RATIO_MASK		GENMASK(7, 0)
#define VPU_HW_BTRS_MTL_FMIN_FUSE_PN_RATIO_MASK			GENMASK(15, 8)

#define VPU_HW_BTRS_MTL_FMAX_FUSE				0x00000028u
#define VPU_HW_BTRS_MTL_FMAX_FUSE_MAX_RATIO_MASK		GENMASK(7, 0)

#define VPU_HW_BTRS_MTL_TILE_FUSE				0x0000002cu
#define VPU_HW_BTRS_MTL_TILE_FUSE_VALID_MASK			BIT_MASK(0)
#define VPU_HW_BTRS_MTL_TILE_FUSE_SKU_MASK			GENMASK(3, 2)

#define VPU_HW_BTRS_MTL_LOCAL_INT_MASK				0x00000030u
#define VPU_HW_BTRS_MTL_GLOBAL_INT_MASK				0x00000034u

#define VPU_HW_BTRS_MTL_PLL_STATUS				0x00000040u
#define VPU_HW_BTRS_MTL_PLL_STATUS_LOCK_MASK			BIT_MASK(1)

#define VPU_HW_BTRS_MTL_VPU_STATUS				0x00000044u
#define VPU_HW_BTRS_MTL_VPU_STATUS_READY_MASK			BIT_MASK(0)
#define VPU_HW_BTRS_MTL_VPU_STATUS_IDLE_MASK			BIT_MASK(1)

#define VPU_HW_BTRS_MTL_VPU_D0I3_CONTROL			0x00000060u
#define VPU_HW_BTRS_MTL_VPU_D0I3_CONTROL_INPROGRESS_MASK	BIT_MASK(0)
#define VPU_HW_BTRS_MTL_VPU_D0I3_CONTROL_I3_MASK		BIT_MASK(2)

#define VPU_HW_BTRS_MTL_VPU_IP_RESET				0x00000050u
#define VPU_HW_BTRS_MTL_VPU_IP_RESET_TRIGGER_MASK		BIT_MASK(0)

#define VPU_HW_BTRS_MTL_VPU_TELEMETRY_OFFSET			0x00000080u
#define VPU_HW_BTRS_MTL_VPU_TELEMETRY_SIZE			0x00000084u
#define VPU_HW_BTRS_MTL_VPU_TELEMETRY_ENABLE			0x00000088u

#define VPU_HW_BTRS_MTL_ATS_ERR_LOG_0				0x000000a0u
#define VPU_HW_BTRS_MTL_ATS_ERR_LOG_1				0x000000a4u
#define VPU_HW_BTRS_MTL_ATS_ERR_CLEAR				0x000000a8u

#define VPU_HW_BTRS_MTL_UFI_ERR_LOG				0x000000b0u
#define VPU_HW_BTRS_MTL_UFI_ERR_LOG_CQ_ID_MASK			GENMASK(11, 0)
#define VPU_HW_BTRS_MTL_UFI_ERR_LOG_AXI_ID_MASK			GENMASK(19, 12)
#define VPU_HW_BTRS_MTL_UFI_ERR_LOG_OPCODE_MASK			GENMASK(24, 20)

#define VPU_HW_BTRS_MTL_UFI_ERR_CLEAR				0x000000b4u

#endif /* __IVPU_HW_BTRS_MTL_REG_H__ */
