/*
 * Copyright (c) 2010 Google Inc. All rights reserved.
 * Copyright (c) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "HTMLFormControlElement.h"

namespace WebCore {

class DOMTokenList;

class HTMLOutputElement final : public HTMLFormControlElement {
    WTF_MAKE_TZONE_OR_ISO_ALLOCATED(HTMLOutputElement);
    WTF_OVERRIDE_DELETE_FOR_CHECKED_PTR(HTMLOutputElement);
public:
    static Ref<HTMLOutputElement> create(const QualifiedName&, Document&, HTMLFormElement*);
    static Ref<HTMLOutputElement> create(Document&);
    ~HTMLOutputElement();

    String value() const;
    void setValue(String&&);
    String defaultValue() const;
    void setDefaultValue(String&&);
    DOMTokenList& htmlFor();
    
private:
    HTMLOutputElement(const QualifiedName&, Document&, HTMLFormElement*);

    bool canContainRangeEndPoint() const final { return false; }
    bool computeWillValidate() const final { return false; }
    void attributeChanged(const QualifiedName&, const AtomString& oldValue, const AtomString& newValue, AttributeModificationReason) final;

    const AtomString& formControlType() const final;
    bool isEnumeratable() const final { return true; }
    bool isLabelable() const final { return true; }
    bool supportsFocus() const final;
    void reset() final;

    String m_defaultValueOverride;
    std::unique_ptr<DOMTokenList> m_forTokens;
};

} // namespace WebCore
