/* Copyright (C) 2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is generated by generate-gpup-webgl. Do not edit.
// This file should be included in the private section of the
// RemoteGraphicsContextGL implementations.
#pragma once
    void activeTexture(uint32_t texture);
    void attachShader(uint32_t program, uint32_t shader);
    void bindAttribLocation(uint32_t arg0, uint32_t index, CString&& name);
    void bindBuffer(uint32_t target, uint32_t arg1);
    void bindFramebuffer(uint32_t target, uint32_t arg1);
    void bindRenderbuffer(uint32_t target, uint32_t arg1);
    void bindTexture(uint32_t target, uint32_t arg1);
    void blendColor(float red, float green, float blue, float alpha);
    void blendEquation(uint32_t mode);
    void blendEquationSeparate(uint32_t modeRGB, uint32_t modeAlpha);
    void blendFunc(uint32_t sfactor, uint32_t dfactor);
    void blendFuncSeparate(uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha);
    void checkFramebufferStatus(uint32_t target, CompletionHandler<void(uint32_t)>&&);
    void clear(uint32_t mask);
    void clearColor(float red, float green, float blue, float alpha);
    void clearDepth(float depth);
    void clearStencil(int32_t s);
    void colorMask(bool red, bool green, bool blue, bool alpha);
    void compileShader(uint32_t arg0);
    void copyTexImage2D(uint32_t target, int32_t level, uint32_t internalformat, int32_t x, int32_t y, int32_t width, int32_t height, int32_t border);
    void copyTexSubImage2D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t x, int32_t y, int32_t width, int32_t height);
    void createBuffer(uint32_t name);
    void createFramebuffer(uint32_t name);
    void createProgram(uint32_t name);
    void createRenderbuffer(uint32_t name);
    void createShader(uint32_t name, uint32_t arg0);
    void createTexture(uint32_t name);
    void cullFace(uint32_t mode);
    void deleteBuffer(uint32_t arg0);
    void deleteFramebuffer(uint32_t arg0);
    void deleteProgram(uint32_t arg0);
    void deleteRenderbuffer(uint32_t arg0);
    void deleteShader(uint32_t arg0);
    void deleteTexture(uint32_t arg0);
    void depthFunc(uint32_t func);
    void depthMask(bool flag);
    void depthRange(float zNear, float zFar);
    void detachShader(uint32_t arg0, uint32_t arg1);
    void disable(uint32_t cap);
    void disableVertexAttribArray(uint32_t index);
    void drawArrays(uint32_t mode, int32_t first, int32_t count);
    void drawElements(uint32_t mode, int32_t count, uint32_t type, uint64_t offset);
    void enable(uint32_t cap);
    void enableVertexAttribArray(uint32_t index);
    void finish();
    void flush();
    void framebufferRenderbuffer(uint32_t target, uint32_t attachment, uint32_t renderbuffertarget, uint32_t arg3);
    void framebufferTexture2D(uint32_t target, uint32_t attachment, uint32_t textarget, uint32_t arg3, int32_t level);
    void frontFace(uint32_t mode);
    void generateMipmap(uint32_t target);
    void activeAttribs(uint32_t program, CompletionHandler<void(Vector<WebCore::GCGLAttribActiveInfo>&&)>&&);
    void activeUniforms(uint32_t program, CompletionHandler<void(Vector<WebCore::GCGLUniformActiveInfo>&&)>&&);
    void getBufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getString(uint32_t name, CompletionHandler<void(CString&&)>&&);
    void getFloatv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const float>)>&&);
    void getIntegerv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const int32_t>)>&&);
    void getIntegeri_v(uint32_t pname, uint32_t index, CompletionHandler<void(std::span<const int32_t, 4>)>&&); // NOLINT
    void getInteger64(uint32_t pname, CompletionHandler<void(int64_t)>&&);
    void getInteger64i(uint32_t pname, uint32_t index, CompletionHandler<void(int64_t)>&&);
    void getProgrami(uint32_t program, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getBooleanv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const bool>)>&&);
    void getFramebufferAttachmentParameteri(uint32_t target, uint32_t attachment, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getProgramInfoLog(uint32_t arg0, CompletionHandler<void(CString&&)>&&);
    void getRenderbufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getShaderi(uint32_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getShaderInfoLog(uint32_t arg0, CompletionHandler<void(CString&&)>&&);
    void getShaderPrecisionFormat(uint32_t shaderType, uint32_t precisionType, CompletionHandler<void(std::span<const int32_t, 2>, int32_t)>&&);
    void getTexParameterf(uint32_t target, uint32_t pname, CompletionHandler<void(float)>&&);
    void getTexParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getUniformfv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const float>)>&&);
    void getUniformiv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const int32_t>)>&&);
    void getUniformuiv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const uint32_t>)>&&);
    void getVertexAttribOffset(uint32_t index, uint32_t pname, CompletionHandler<void(uint64_t)>&&);
    void hint(uint32_t target, uint32_t mode);
    void isBuffer(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void isEnabled(uint32_t cap, CompletionHandler<void(bool)>&&);
    void isFramebuffer(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void isProgram(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void isRenderbuffer(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void isShader(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void isTexture(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void lineWidth(float arg0);
    void linkProgram(uint32_t arg0);
    void pixelStorei(uint32_t pname, int32_t param);
    void polygonOffset(float factor, float units);
    void renderbufferStorage(uint32_t target, uint32_t internalformat, int32_t width, int32_t height);
    void sampleCoverage(float value, bool invert);
    void scissor(int32_t x, int32_t y, int32_t width, int32_t height);
    void shaderSource(uint32_t arg0, CString&& arg1);
    void stencilFunc(uint32_t func, int32_t ref, uint32_t mask);
    void stencilFuncSeparate(uint32_t face, uint32_t func, int32_t ref, uint32_t mask);
    void stencilMask(uint32_t mask);
    void stencilMaskSeparate(uint32_t face, uint32_t mask);
    void stencilOp(uint32_t fail, uint32_t zfail, uint32_t zpass);
    void stencilOpSeparate(uint32_t face, uint32_t fail, uint32_t zfail, uint32_t zpass);
    void texParameterf(uint32_t target, uint32_t pname, float param);
    void texParameteri(uint32_t target, uint32_t pname, int32_t param);
    void uniform1f(int32_t location, float x);
    void uniform1fv(int32_t location, std::span<const float>&& v);
    void uniform1i(int32_t location, int32_t x);
    void uniform1iv(int32_t location, std::span<const int32_t>&& v);
    void uniform2f(int32_t location, float x, float y);
    void uniform2fv(int32_t location, std::span<const float>&& v);
    void uniform2i(int32_t location, int32_t x, int32_t y);
    void uniform2iv(int32_t location, std::span<const int32_t>&& v);
    void uniform3f(int32_t location, float x, float y, float z);
    void uniform3fv(int32_t location, std::span<const float>&& v);
    void uniform3i(int32_t location, int32_t x, int32_t y, int32_t z);
    void uniform3iv(int32_t location, std::span<const int32_t>&& v);
    void uniform4f(int32_t location, float x, float y, float z, float w);
    void uniform4fv(int32_t location, std::span<const float>&& v);
    void uniform4i(int32_t location, int32_t x, int32_t y, int32_t z, int32_t w);
    void uniform4iv(int32_t location, std::span<const int32_t>&& v);
    void uniformMatrix2fv(int32_t location, bool transpose, std::span<const float>&& value);
    void uniformMatrix3fv(int32_t location, bool transpose, std::span<const float>&& value);
    void uniformMatrix4fv(int32_t location, bool transpose, std::span<const float>&& value);
    void useProgram(uint32_t arg0);
    void validateProgram(uint32_t arg0);
    void vertexAttrib1f(uint32_t index, float x);
    void vertexAttrib1fv(uint32_t index, std::span<const float, 1>&& values);
    void vertexAttrib2f(uint32_t index, float x, float y);
    void vertexAttrib2fv(uint32_t index, std::span<const float, 2>&& values);
    void vertexAttrib3f(uint32_t index, float x, float y, float z);
    void vertexAttrib3fv(uint32_t index, std::span<const float, 3>&& values);
    void vertexAttrib4f(uint32_t index, float x, float y, float z, float w);
    void vertexAttrib4fv(uint32_t index, std::span<const float, 4>&& values);
    void vertexAttribPointer(uint32_t index, int32_t size, uint32_t type, bool normalized, int32_t stride, uint64_t offset);
    void viewport(int32_t x, int32_t y, int32_t width, int32_t height);
    void bufferData0(uint32_t target, uint64_t arg1, uint32_t usage);
    void bufferData1(uint32_t target, std::span<const uint8_t>&& data, uint32_t usage);
    void bufferSubData(uint32_t target, uint64_t offset, std::span<const uint8_t>&& data);
    void readPixelsBufferObject(WebCore::IntRect&& arg0, uint32_t format, uint32_t type, uint64_t offset, int32_t alignment, int32_t rowLength);
    void texImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels);
    void texImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, uint64_t offset);
    void texSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels);
    void texSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, uint64_t offset);
    void compressedTexImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, std::span<const uint8_t>&& data);
    void compressedTexImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, uint64_t offset);
    void compressedTexSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, std::span<const uint8_t>&& data);
    void compressedTexSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, uint64_t offset);
    void drawArraysInstanced(uint32_t mode, int32_t first, int32_t count, int32_t primcount);
    void drawElementsInstanced(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t primcount);
    void vertexAttribDivisor(uint32_t index, uint32_t divisor);
    void createVertexArray(uint32_t name);
    void deleteVertexArray(uint32_t arg0);
    void isVertexArray(uint32_t arg0, CompletionHandler<void(bool)>&&);
    void bindVertexArray(uint32_t arg0);
    void copyBufferSubData(uint32_t readTarget, uint32_t writeTarget, uint64_t readOffset, uint64_t writeOffset, uint64_t arg4);
    void blitFramebuffer(int32_t srcX0, int32_t srcY0, int32_t srcX1, int32_t srcY1, int32_t dstX0, int32_t dstY0, int32_t dstX1, int32_t dstY1, uint32_t mask, uint32_t filter);
    void framebufferTextureLayer(uint32_t target, uint32_t attachment, uint32_t texture, int32_t level, int32_t layer);
    void readBuffer(uint32_t src);
    void renderbufferStorageMultisample(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height);
    void texStorage2D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height);
    void texStorage3D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height, int32_t depth);
    void texImage3D0(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels);
    void texImage3D1(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, uint64_t offset);
    void texSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels);
    void texSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, uint64_t offset);
    void copyTexSubImage3D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t x, int32_t y, int32_t width, int32_t height);
    void compressedTexImage3D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, std::span<const uint8_t>&& data);
    void compressedTexImage3D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, uint64_t offset);
    void compressedTexSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, std::span<const uint8_t>&& data);
    void compressedTexSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, uint64_t offset);
    void getFragDataLocation(uint32_t program, CString&& name, CompletionHandler<void(int32_t)>&&);
    void uniform1ui(int32_t location, uint32_t v0);
    void uniform2ui(int32_t location, uint32_t v0, uint32_t v1);
    void uniform3ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2);
    void uniform4ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2, uint32_t v3);
    void uniform1uiv(int32_t location, std::span<const uint32_t>&& data);
    void uniform2uiv(int32_t location, std::span<const uint32_t>&& data);
    void uniform3uiv(int32_t location, std::span<const uint32_t>&& data);
    void uniform4uiv(int32_t location, std::span<const uint32_t>&& data);
    void uniformMatrix2x3fv(int32_t location, bool transpose, std::span<const float>&& data);
    void uniformMatrix3x2fv(int32_t location, bool transpose, std::span<const float>&& data);
    void uniformMatrix2x4fv(int32_t location, bool transpose, std::span<const float>&& data);
    void uniformMatrix4x2fv(int32_t location, bool transpose, std::span<const float>&& data);
    void uniformMatrix3x4fv(int32_t location, bool transpose, std::span<const float>&& data);
    void uniformMatrix4x3fv(int32_t location, bool transpose, std::span<const float>&& data);
    void vertexAttribI4i(uint32_t index, int32_t x, int32_t y, int32_t z, int32_t w);
    void vertexAttribI4iv(uint32_t index, std::span<const int32_t, 4>&& values);
    void vertexAttribI4ui(uint32_t index, uint32_t x, uint32_t y, uint32_t z, uint32_t w);
    void vertexAttribI4uiv(uint32_t index, std::span<const uint32_t, 4>&& values);
    void vertexAttribIPointer(uint32_t index, int32_t size, uint32_t type, int32_t stride, uint64_t offset);
    void drawRangeElements(uint32_t mode, uint32_t start, uint32_t end, int32_t count, uint32_t type, uint64_t offset);
    void clearBufferiv(uint32_t buffer, int32_t drawbuffer, std::span<const int32_t>&& values);
    void clearBufferuiv(uint32_t buffer, int32_t drawbuffer, std::span<const uint32_t>&& values);
    void clearBufferfv(uint32_t buffer, int32_t drawbuffer, std::span<const float>&& values);
    void clearBufferfi(uint32_t buffer, int32_t drawbuffer, float depth, int32_t stencil);
    void createQuery(uint32_t name);
    void deleteQuery(uint32_t query);
    void isQuery(uint32_t query, CompletionHandler<void(bool)>&&);
    void beginQuery(uint32_t target, uint32_t query);
    void endQuery(uint32_t target);
    void getQuery(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getQueryObjectui(uint32_t query, uint32_t pname, CompletionHandler<void(uint32_t)>&&);
    void createSampler(uint32_t name);
    void deleteSampler(uint32_t sampler);
    void isSampler(uint32_t sampler, CompletionHandler<void(bool)>&&);
    void bindSampler(uint32_t unit, uint32_t sampler);
    void samplerParameteri(uint32_t sampler, uint32_t pname, int32_t param);
    void samplerParameterf(uint32_t sampler, uint32_t pname, float param);
    void getSamplerParameterf(uint32_t sampler, uint32_t pname, CompletionHandler<void(float)>&&);
    void getSamplerParameteri(uint32_t sampler, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void fenceSync(uint32_t condition, uint32_t flags, CompletionHandler<void(uint64_t)>&&);
    void isSync(uint64_t arg0, CompletionHandler<void(bool)>&&);
    void deleteSync(uint64_t arg0);
    void clientWaitSync(uint64_t arg0, uint32_t flags, uint64_t timeout, CompletionHandler<void(uint32_t)>&&);
    void waitSync(uint64_t arg0, uint32_t flags, int64_t timeout);
    void getSynci(uint64_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void createTransformFeedback(uint32_t name);
    void deleteTransformFeedback(uint32_t id);
    void isTransformFeedback(uint32_t id, CompletionHandler<void(bool)>&&);
    void bindTransformFeedback(uint32_t target, uint32_t id);
    void beginTransformFeedback(uint32_t primitiveMode);
    void endTransformFeedback();
    void transformFeedbackVaryings(uint32_t program, Vector<CString>&& varyings, uint32_t bufferMode);
    void getTransformFeedbackVarying(uint32_t program, uint32_t index, CompletionHandler<void(std::optional<WebCore::GCGLTransformFeedbackActiveInfo>&&)>&&);
    void pauseTransformFeedback();
    void resumeTransformFeedback();
    void bindBufferBase(uint32_t target, uint32_t index, uint32_t buffer);
    void bindBufferRange(uint32_t target, uint32_t index, uint32_t buffer, uint64_t offset, uint64_t arg4);
    void getUniformBlockIndex(uint32_t program, CString&& uniformBlockName, CompletionHandler<void(uint32_t)>&&);
    void getActiveUniformBlockName(uint32_t program, uint32_t uniformBlockIndex, CompletionHandler<void(CString&&)>&&);
    void uniformBlockBinding(uint32_t program, uint32_t uniformBlockIndex, uint32_t uniformBlockBinding);
    void getActiveUniformBlockiv(uint32_t program, uint32_t uniformBlockIndex, uint32_t pname, uint64_t paramsSize, CompletionHandler<void(std::span<const int32_t>)>&&);
    void getTranslatedShaderSourceANGLE(uint32_t arg0, CompletionHandler<void(CString&&)>&&);
    void createQueryEXT(uint32_t name);
    void deleteQueryEXT(uint32_t query);
    void isQueryEXT(uint32_t query, CompletionHandler<void(bool)>&&);
    void beginQueryEXT(uint32_t target, uint32_t query);
    void endQueryEXT(uint32_t target);
    void queryCounterEXT(uint32_t query, uint32_t target);
    void getQueryiEXT(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getQueryObjectiEXT(uint32_t query, uint32_t pname, CompletionHandler<void(int32_t)>&&);
    void getQueryObjectui64EXT(uint32_t query, uint32_t pname, CompletionHandler<void(uint64_t)>&&);
    void getInteger64EXT(uint32_t pname, CompletionHandler<void(int64_t)>&&);
    void enableiOES(uint32_t target, uint32_t index);
    void disableiOES(uint32_t target, uint32_t index);
    void blendEquationiOES(uint32_t buf, uint32_t mode);
    void blendEquationSeparateiOES(uint32_t buf, uint32_t modeRGB, uint32_t modeAlpha);
    void blendFunciOES(uint32_t buf, uint32_t src, uint32_t dst);
    void blendFuncSeparateiOES(uint32_t buf, uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha);
    void colorMaskiOES(uint32_t buf, bool red, bool green, bool blue, bool alpha);
    void drawArraysInstancedBaseInstanceANGLE(uint32_t mode, int32_t first, int32_t count, int32_t instanceCount, uint32_t baseInstance);
    void drawElementsInstancedBaseVertexBaseInstanceANGLE(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t instanceCount, int32_t baseVertex, uint32_t baseInstance);
    void clipControlEXT(uint32_t origin, uint32_t depth);
    void provokingVertexANGLE(uint32_t provokeMode);
    void polygonModeANGLE(uint32_t face, uint32_t mode);
    void polygonOffsetClampEXT(float factor, float units, float clamp);
    void renderbufferStorageMultisampleANGLE(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height);
    void getInternalformativ(uint32_t target, uint32_t internalformat, uint32_t pname, uint64_t paramsSize, CompletionHandler<void(std::span<const int32_t>)>&&);
#if ENABLE(WEBXR)
    void createExternalImage(uint32_t name, WebCore::GraphicsContextGL::ExternalImageSource&& arg0, uint32_t internalFormat, int32_t layer);
    void deleteExternalImage(uint32_t handle);
    void bindExternalImage(uint32_t target, uint32_t arg1);
    void createExternalSync(uint32_t name, WebCore::GraphicsContextGL::ExternalSyncSource&& arg0);
    void deleteExternalSync(uint32_t arg0);
    void enableRequiredWebXRExtensions(CompletionHandler<void(bool)>&&);
    void addFoveation(WebCore::IntSize&& physicalSizeLeft, WebCore::IntSize&& physicalSizeRight, WebCore::IntSize&& screenSize, std::span<const float>&& horizontalSamplesLeft, std::span<const float>&& verticalSamples, std::span<const float>&& horizontalSamplesRight, CompletionHandler<void(bool)>&&);
    void enableFoveation(uint32_t arg0);
    void disableFoveation();
    void framebufferResolveRenderbuffer(uint32_t target, uint32_t attachment, uint32_t renderbuffertarget, uint32_t arg3);
#endif

