! @(#)ccdsave.prg	19.1 (ES0-DMD) 02/25/03 14:16:01
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!.COPYRIGHT   (C) 1993 European Southern Observatory
!.IDENT       ccdsave.prg
!.AUTHOR      Rein H. Warmels,  ESO - Garching
!.KEYWORDS    CCD, imaging, context saving
!.PURPOSE     Command SAVE/CCD
!.VERSION     920526 RHW Creation
!.VERSION     930516 RHW Check on existence of reduction table
!-------------------------------------------------------
DEFINE/PARAM P1 ? C    "Session name :"
!
CREATE/TABLE {P1}_CCDSAVE 1 1 NULL
! 
!GEneral
! *** General Control Setup 
COPY/KD   IDENT     {P1}_CCDSAVE.tbl IDENT/C/1/20 
COPY/KD   OBSER     {P1}_CCDSAVE.tbl OBSER/C/1/20
COPY/KD   TELES     {P1}_CCDSAVE.tbl TELES/C/1/20
COPY/KD   INSTR     {P1}_CCDSAVE.tbl INSTR/C/1/20
COPY/KD   DETEC     {P1}_CCDSAVE.tbl DETEC/C/1/20
COPY/KD   NPIXX     {P1}_CCDSAVE.tbl NPIXX/I/1/1
COPY/KD   NPIXY     {P1}_CCDSAVE.tbl NPIXY/I/1/1
COPY/KD   SPIXX     {P1}_CCDSAVE.tbl SPIXX/I/1/1
COPY/KD   SPIXY     {P1}_CCDSAVE.tbl SPIXY/I/1/1
COPY/KD   DIRECT    {P1}_CCDSAVE.tbl DIRECT/C/1/3
COPY/KD   BINNING   {P1}_CCDSAVE.tbl BINNING/I/1/2
COPY/KD   READMOD   {P1}_CCDSAVE.tbl READMOD/C/1/4
COPY/KD   READON    {P1}_CCDSAVE.tbl READON/R/1/1 
COPY/KD   AD_VAL    {P1}_CCDSAVE.tbl AD_VAL/R/1/1 
!
COPY/KD   .IDENT    {P1}_CCDSAVE.tbl .IDENT/C/1/20
COPY/KD   .OBSER    {P1}_CCDSAVE.tbl .OBSER/C/1/20
COPY/KD   .TELES    {P1}_CCDSAVE.tbl .TELES/C/1/20
COPY/KD   .INSTR    {P1}_CCDSAVE.tbl .INSTR/C/1/20  
COPY/KD   .DETEC    {P1}_CCDSAVE.tbl .DETEC/C/1/20
COPY/KD   .BINNING  {P1}_CCDSAVE.tbl .BINNING/C/1/20
COPY/KD   .DIRECT   {P1}_CCDSAVE.tbl .DIRECT/C/1/20
COPY/KD   .READMOD  {P1}_CCDSAVE.tbl .READMOD/C/1/20
COPY/KD   .READON   {P1}_CCDSAVE.tbl .READON/C/1/20
COPY/KD   .AD_VAL   {P1}_CCDSAVE.tbl .AD_VAL/C/1/20
COPY/KD   EXP_DESC  {P1}_CCDSAVE.tbl EXP_DESC/C/1/20
COPY/KD   O_DESC    {P1}_CCDSAVE.tbl O_DESC/C/1/20
!
COPY/KD   CCD_IN    {P1}_CCDSAVE.tbl CCD_IN/C/1/60
COPY/KD   OV_SEC    {P1}_CCDSAVE.tbl OV_SEC/C/1/40 
COPY/KD   IM_SEC    {P1}_CCDSAVE.tbl IM_SEC/C/1/40
!
!BiaS
! *** general combining parameters
COPY/KD   BS_TYP    {P1}_CCDSAVE.tbl BS_TYP/C/1/60
COPY/KD   BS_SIG    {P1}_CCDSAVE.tbl BS_SIG/C/1/3 
COPY/KD   BS_MET    {P1}_CCDSAVE.tbl BS_MET/C/1/20 
COPY/KD   BS_DEL    {P1}_CCDSAVE.tbl BS_DEL/C/1/3
COPY/KD   BS_EXP    {P1}_CCDSAVE.tbl BS_EXP/C/1/3 
COPY/KD   BS_STA    {P1}_CCDSAVE.tbl BS_STA/C/1/6
COPY/KD   BS_SCA    {P1}_CCDSAVE.tbl BS_SCA/C/1/3
COPY/KD   BS_OFF    {P1}_CCDSAVE.tbl BS_OFF/C/1/3
COPY/KD   BS_WEI    {P1}_CCDSAVE.tbl BS_WEI/C/1/3
COPY/KD   BS_SEC    {P1}_CCDSAVE.tbl BS_SEC/C/1/40
COPY/KD   BS_RAN    {P1}_CCDSAVE.tbl BS_RAN/R/1/2 
COPY/KD   BS_CLP    {P1}_CCDSAVE.tbl BS_CLP/R/1/2
COPY/KD   BS_NUL    {P1}_CCDSAVE.tbl BS_NUL/C/1/20
!
!DarK
! *** general combining parameters
COPY/KD   DK_TYP    {P1}_CCDSAVE.tbl DK_TYP/C/1/60 
COPY/KD   DK_SIG    {P1}_CCDSAVE.tbl DK_SIG/C/1/3
COPY/KD   DK_MET    {P1}_CCDSAVE.tbl DK_MET/C/1/20
COPY/KD   DK_DEL    {P1}_CCDSAVE.tbl DK_DEL/C/1/3 
COPY/KD   DK_EXP    {P1}_CCDSAVE.tbl DK_EXP/C/1/3
COPY/KD   DK_STA    {P1}_CCDSAVE.tbl DK_STA/C/1/6
COPY/KD   DK_SCA    {P1}_CCDSAVE.tbl DK_SCA/C/1/3
COPY/KD   DK_OFF    {P1}_CCDSAVE.tbl DK_OFF/C/1/3 
COPY/KD   DK_WEI    {P1}_CCDSAVE.tbl DK_WEI/C/1/3
COPY/KD   DK_SEC    {P1}_CCDSAVE.tbl DK_SEC/C/1/40
COPY/KD   DK_RAN    {P1}_CCDSAVE.tbl DK_RAN/R/1/2 
COPY/KD   DK_CLP    {P1}_CCDSAVE.tbl DK_CLP/R/1/2
COPY/KD   DK_NUL    {P1}_CCDSAVE.tbl DK_NUL/C/1/20
!
!Flat
! *** general combining parameters
COPY/KD   FF_TYP    {P1}_CCDSAVE.tbl FF_TYP/C/1/60
COPY/KD   FF_SIG    {P1}_CCDSAVE.tbl FF_SIG/C/1/3
COPY/KD   FF_MET    {P1}_CCDSAVE.tbl FF_MET/C/1/20 
COPY/KD   FF_DEL    {P1}_CCDSAVE.tbl FF_DEL/C/1/3  
COPY/KD   FF_EXP    {P1}_CCDSAVE.tbl FF_EXP/C/1/3 
COPY/KD   FF_STA    {P1}_CCDSAVE.tbl FF_STA/C/1/6
COPY/KD   FF_SCA    {P1}_CCDSAVE.tbl FF_SCA/C/1/3
COPY/KD   FF_OFF    {P1}_CCDSAVE.tbl FF_OFF/C/1/3 
COPY/KD   FF_WEI    {P1}_CCDSAVE.tbl FF_WEI/C/1/3 
COPY/KD   FF_SEC    {P1}_CCDSAVE.tbl FF_SEC/C/1/40
COPY/KD   FF_RAN    {P1}_CCDSAVE.tbl FF_RAN/R/1/2 
COPY/KD   FF_CLP    {P1}_CCDSAVE.tbl FF_CLP/R/1/2 
COPY/KD   FF_NUL    {P1}_CCDSAVE.tbl FF_NUL/C/1/20 
!
!SKY
! *** general combining parameters
COPY/KD   SK_TYP    {P1}_CCDSAVE.tbl SK_TYP/C/1/60
COPY/KD   SK_SIG    {P1}_CCDSAVE.tbl SK_SIG/C/1/3
COPY/KD   SK_MET    {P1}_CCDSAVE.tbl SK_MET/C/1/2
COPY/KD   SK_DEL    {P1}_CCDSAVE.tbl SK_DEL/C/1/3 
COPY/KD   SK_EXP    {P1}_CCDSAVE.tbl SK_EXP/C/1/3
COPY/KD   SK_STA    {P1}_CCDSAVE.tbl SK_STA/C/1/6
COPY/KD   SK_SCA    {P1}_CCDSAVE.tbl SK_SCA/C/1/3
COPY/KD   SK_OFF    {P1}_CCDSAVE.tbl SK_OFF/C/1/3 
COPY/KD   SK_WEI    {P1}_CCDSAVE.tbl SK_WEI/C/1/3 
COPY/KD   SK_SEC    {P1}_CCDSAVE.tbl SK_SEC/C/1/40
COPY/KD   SK_RAN    {P1}_CCDSAVE.tbl SK_RAN/R/1/2 
COPY/KD   SK_CLP    {P1}_CCDSAVE.tbl SK_CLP/R/1/2
COPY/KD   SK_NUL    {P1}_CCDSAVE.tbl SK_NUL/C/1/20
!
!OThers
! *** general combining parameters
COPY/KD   OT_TYP    {P1}_CCDSAVE.tbl OT_TYP/C/1/60
COPY/KD   OT_SIG    {P1}_CCDSAVE.tbl OT_SIG/C/1/3
COPY/KD   OT_MET    {P1}_CCDSAVE.tbl OT_MET/C/1/20
COPY/KD   OT_DEL    {P1}_CCDSAVE.tbl OT_DEL/C/1/3 
COPY/KD   OT_EXP    {P1}_CCDSAVE.tbl OT_EXP/C/1/3
COPY/KD   OT_STA    {P1}_CCDSAVE.tbl OT_STA/C/1/6
COPY/KD   OT_SCA    {P1}_CCDSAVE.tbl OT_SCA/C/1/3
COPY/KD   OT_OFF    {P1}_CCDSAVE.tbl OT_OFF/C/1/3 
COPY/KD   OT_WEI    {P1}_CCDSAVE.tbl OT_WEI/C/1/3 
COPY/KD   OT_SEC    {P1}_CCDSAVE.tbl OT_SEC/C/1/40
COPY/KD   OT_RAN    {P1}_CCDSAVE.tbl OT_RAN/R/1/2 
COPY/KD   OT_CLP    {P1}_CCDSAVE.tbl OT_CLP/R/1/2
COPY/KD   OT_NUL    {P1}_CCDSAVE.tbl OT_NUL/C/1/20
!
!MOsaic
! *** parametsr for the mosaic facility
COPY/KD   MO_SEC    {P1}_CCDSAVE.tbl MO_SEC/C/1/40
COPY/KD   MO_SUBT   {P1}_CCDSAVE.tbl MO_SUBT/C/1/40
COPY/KD   MO_CORN   {P1}_CCDSAVE.tbl MO_CORN/C/1/2
COPY/KD   MO_DIREC  {P1}_CCDSAVE.tbl MO_DIREC/C/1/3
COPY/KD   MO_RAST   {P1}_CCDSAVE.tbl MO_RAST/C/1/3
COPY/KD   MO_OVER   {P1}_CCDSAVE.tbl MO_OVER/I/1/2
COPY/KD   MO_INTER  {P1}_CCDSAVE.tbl MO_INTER/C/1/20
COPY/KD   MO_MNPX   {P1}_CCDSAVE.tbl MO_MNPX/I/1/1
COPY/KD   MO_TRIM   {P1}_CCDSAVE.tbl MO_TRIM/I/1/4
COPY/KD   MO_NUL    {P1}_CCDSAVE.tbl MO_NUL/C/1/20
!
!OVerscan
! *** parameters for the overscan fitting
COPY/KD   OV_IMODE  {P1}_CCDSAVE.tbl OV_IMODE/C/1/3 
COPY/KD   OV_FUNCT  {P1}_CCDSAVE.tbl OV_FUNCT/C/1/20
COPY/KD   OV_ORDER  {P1}_CCDSAVE.tbl OV_ORDER/I/1/1
COPY/KD   OV_AVER   {P1}_CCDSAVE.tbl OV_AVER/I/1/1
COPY/KD   OV_ITER   {P1}_CCDSAVE.tbl OV_ITER/I/1/1
COPY/KD   OV_REJEC  {P1}_CCDSAVE.tbl OV_REJECT/R/1/2
!
!FXpix
! *** parameters for the bad pxuiel correction
COPY/KD   FX_TABLE  {P1}_CCDSAVE.tbl FX_TABLE/C/1/60
COPY/KD   FX_METH   {P1}_CCDSAVE.tbl FX_METH/C/1/3
COPY/KD   FX_FACT   {P1}_CCDSAVE.tbl FX_FACT/I/1/2
COPY/KD   FX_FPAR   {P1}_CCDSAVE.tbl FX_FPAR/I/1/3
COPY/KD   FX_NOISE  {P1}_CCDSAVE.tbl FX_NOISE/C/1/3
!
!MKILLU    
! *** parameters for illumination and fringe correction
COPY/KD   IL_TYP    {P1}_CCDSAVE.tbl IL_TYP/C/1/60
COPY/KD   FR_TYP    {P1}_CCDSAVE.tbl FR_TYP/C/1/60
COPY/KD   IL_XBOX   {P1}_CCDSAVE.tbl IL_XBOX/R/1/2
COPY/KD   IL_YBOX   {P1}_CCDSAVE.tbl IL_YBOX/R/1/2
COPY/KD   IL_CLIP   {P1}_CCDSAVE.tbl IL_CLIP/C/1/3 
COPY/KD   IL_SIGMA  {P1}_CCDSAVE.tbl IL_SIGMA/R/1/2
!
!SCIENCE
! *** parameters for the science frame calibration
COPY/KD   SC_TYP    {P1}_CCDSAVE.tbl SC_TYP/C/1/60  
COPY/KD   SC_PROC   {P1}_CCDSAVE.tbl SC_PROC/C/1/3
COPY/KD   SC_SCAN   {P1}_CCDSAVE.tbl SC_SCCOR/C/1/3 
COPY/KD   SC_TRIM   {P1}_CCDSAVE.tbl SC_TRIM/C/1/3 
COPY/KD   SC_FXPIX  {P1}_CCDSAVE.tbl SC_FXPIX/C/1/3 
COPY/KD   SC_BSCOR  {P1}_CCDSAVE.tbl SC_BSCOR/C/1/3 
COPY/KD   SC_BSFRM  {P1}_CCDSAVE.tbl SC_BSFRM/C/1/60
COPY/KD   SC_DKCOR  {P1}_CCDSAVE.tbl SC_DKCOR/C/1/3
COPY/KD   SC_DKFRM  {P1}_CCDSAVE.tbl SC_DKFRM/C/1/60
COPY/KD   SC_FFCOR  {P1}_CCDSAVE.tbl SC_FFCOR/C/1/3
COPY/KD   SC_FFFRM  {P1}_CCDSAVE.tbl SC_FFFRM/C/1/60 
COPY/KD   SC_ILCOR  {P1}_CCDSAVE.tbl SC_ILCOR/C/1/3
COPY/KD   SC_ILFRM  {P1}_CCDSAVE.tbl SC_ILFRM/C/1/60
COPY/KD   SC_FRCOR  {P1}_CCDSAVE.tbl SC_FRCOR/C/1/3
COPY/KD   SC_FRFRM  {P1}_CCDSAVE.tbl SC_FRFRM/C/1/60
! 
! *** correction factors and error keywords
COPY/KD   REDUCT    {P1}_CCDSAVE.tbl REDUCT/C/1/8
COPY/KD   CCDMEAN   {P1}_CCDSAVE.tbl CCDMEAN/R/1/1
COPY/KD   CCDDARK   {P1}_CCDSAVE.tbl CCDDARK/R/1/1
COPY/KD   CCDFLAT   {P1}_CCDSAVE.tbl CCDFLAT/R/1/1
COPY/KD   CCDILLUM  {P1}_CCDSAVE.tbl CCDILLUM/R/1/1
COPY/KD   CCDFRING  {P1}_CCDSAVE.tbl CCDFRING/R/1/1
!
! *** here for the standard column names
COPY/KD   SC_COL    {P1}_CCDSAVE.tbl SC_COL/C/1/60  
COPY/KD   BS_COL    {P1}_CCDSAVE.tbl BS_COL/C/1/60 
COPY/KD   DK_COL    {P1}_CCDSAVE.tbl DK_COL/C/1/60
COPY/KD   FF_COL    {P1}_CCDSAVE.tbl FF_COL/C/1/60
COPY/KD   SK_COL    {P1}_CCDSAVE.tbl SK_COL/C/1/60 
COPY/KD   IL_COL    {P1}_CCDSAVE.tbl IL_COL/C/1/60
COPY/KD   FR_COL    {P1}_CCDSAVE.tbl FR_COL/C/1/60 

SAVINI/CCD {P1}_CCDSAVE.tbl WRITE
WRITE/OUT "*** INFO: CCD session is saved <{P1}_CCDSAVE.tbl>"
!
RETURN









