/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/WelcomePage.ui")]
public class WelcomePage : BasicNavigationPage
{
  signal void back_up();
  signal void browse(DejaDup.Backend backend);

  [GtkChild]
  unowned Adw.StatusPage status_page;

  construct {
    status_page.icon_name = Config.ICON_NAME;
  }

  [GtkCallback]
  void on_initial_backup()
  {
    var dlg = new FirstBackupDialog();
    dlg.back_up.connect(() => {back_up();});
    dlg.present(this);
  }

  [GtkCallback]
  void on_initial_restore()
  {
    var dlg = new RestoreLocationDialog();
    dlg.browse.connect((backend) => {browse(backend);});
    dlg.present(this);
  }
}
