#! /bin/sh
#
### BEGIN INIT INFO
# Provides: crossfire.real-time.com
# Required-Start: $local_fs $network $remote_fs
# Required-Stop: $local_fs $network $remote_fs
# Default-Start:  2 3 4 5
# Default-Stop: 0 1 6
# Short-Description: multiplayer RPG
# Description: Networked graphical RPG/adventure game
### END INIT INFO

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DESC="Crossfire"
NAME=crossfire-server
DAEMON=/usr/sbin/crossfire-server
DAEMON_OPTS="-detach -log /var/log/crossfire/logfile"

test -f $DAEMON || exit 0

# Include crossfire defaults if available
if [ -f /etc/default/crossfire ] ; then
	. /etc/default/crossfire
fi

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.2-14) to ensure that this file is present
# and status_of_proc is working.
. /lib/lsb/init-functions

umask 002

do_start()
{
    # Return
    #   0 if daemon has been started
    #   1 if daemon was already running
    #   2 if daemon could not be started
    start-stop-daemon --start --quiet --user games --exec $DAEMON --test > /dev/null \
        || return 1
    start-stop-daemon --start --quiet --chuid games: --pidfile $PIDFILE --exec $DAEMON -- \
        $DAEMON_ARGS \
        || return 2
}

do_stop()
{
    # Return
    #   0 if daemon has been stopped
    #   1 if daemon was already stopped
    #   2 if daemon could not be stopped
    #   other if a failure occurred
    start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --user games --name $NAME
    RETVAL="$?"
    [ "$RETVAL" = 2 ] && return 2
    # Wait for children to finish too if this is a daemon that forks
    # and if the daemon is only ever run from this initscript.
    # If the above conditions are not satisfied then add some other code
    # that waits for the process to drop all resources that could be
    # needed by services started subsequently.  A last resort is to
    # sleep for some time.
    start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --user games --exec $DAEMON
    [ "$?" = 2 ] && return 2
    return "$RETVAL"
}

case "$1" in
    start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
	    0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
	    2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
    stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
	    0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
	    2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
    status)
	status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
	;;
    restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	    0|1)
		do_start
		case "$?" in
		    0) log_end_msg 0 ;;
		    1) log_end_msg 1 ;; # Old process is still running
		    *) log_end_msg 1 ;; # Failed to start
		esac
		;;
	    *)
		# Failed to stop
		log_end_msg 1
		;;
        esac
        ;;
    *)
	echo "Usage: /etc/init.d/crossfire-server {start|stop|restart|force-reload}"
	exit 3
	;;
esac

:
